// DevModeDlg.cpp : implementation file
/*
DEVMODE is a Windows structure that holds all the printer parameters. It is made up of two parts: public and private. 
The public part contains data that is common to all printers. 
The private part contains data that is specific to a particular printer. 
The private part can be of variable length and can contain anything the printer driver designer decides to include in it.
*/

#include "StdAfx.h"
#include "DevMode.h"
#include "DevModeDlg.h"
#include "WINSPOOL.H"
#include "WINDOWSX.H"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define AMYUNI_PRINTER_NAME		"Amyuni PDF Converter"
#define STRLICENSETO			"Amyuni PDF Converter Evaluation"
#define STRACTIVATIONCODE		"07EFCDAB0100010025AFF1801CB9441306C5739F7D452154D8833B9CECBA2ADE79E3762A69FFC354528A5F4A5811BE3204A0A439F5BA"




/////////////////////////////////////////////////////////////////////////////
// CDevModeDlg dialog

CDevModeDlg::CDevModeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDevModeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDevModeDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDevModeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDevModeDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDevModeDlg, CDialog)
	//{{AFX_MSG_MAP(CDevModeDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_DEVMODE, OnBtnDevmode)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDevModeDlg message handlers

BOOL CDevModeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

//  If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDevModeDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDevModeDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDevModeDlg::OnBtnDevmode() 
{

	bool bResult = TestDevMode();
}

bool CDevModeDlg::TestDevMode()
{

		HANDLE  hPrinter;
		LPDWORD	lpFlags;	// private flags for the PDF printer
		LPDWORD lpMargins;	// margins
		TCHAR   lpDeviceName[] = _T( AMYUNI_PRINTER_NAME );

		if ( !OpenPrinter( lpDeviceName, &hPrinter, NULL ) )
			return FALSE;

		// get real size of DEVMODE
		// DocumentProperties is defined in WINSPOOL.H
		int nSize = DocumentProperties( NULL, hPrinter, NULL /*lpDeviceName*/,
										NULL, NULL, 0 );

		LPDEVMODE lpDevMode = (LPDEVMODE)GlobalAllocPtr( GHND, nSize );

		// fill in the DEVMODE structure with default values.
		if ( DocumentProperties( NULL, hPrinter, lpDeviceName, lpDevMode,
			 lpDevMode, DM_OUT_BUFFER ) != IDOK )
		{
			GlobalFreePtr( lpDevMode );
		}

		lpDevMode->dmColor = DMCOLOR_MONOCHROME;

		// set your specific options here
		lpDevMode->dmFields =  DM_PAPERSIZE /* DM_ORIENTATION  | DM_PAPERWIDTH | DM_PAPERLENGTH */;
		lpDevMode->dmOrientation = DMORIENT_LANDSCAPE;

		//Setting 11 X 17 papersize
		lpDevMode->dmPaperSize = DMPAPER_11X17;   //ex: DMPAPER_11X17,DMPAPER_TABLOID, DMPAPER_LETTER

		//If you want to set a custom paper size
		//lpDevMode->dmPaperWidth = 200;
		//lpDevMode->dmPaperLength = 100;

		
		//int ret = DocumentProperties( NULL, NULL, lpDeviceName,
		//	 lpDevMode, lpDevMode, DM_MODIFY | DM_UPDATE );

		// in case you need to programmatically set or remove the font embedding option
		lpFlags	  = (LPDWORD)((LPBYTE)lpDevMode + lpDevMode->dmSize );
		lpMargins = (LPDWORD)( (LPBYTE)lpDevMode + lpDevMode->dmSize + sizeof( DWORD ) );


		*lpFlags |= DM_EMBED_FONTS|DM_EMBED_STANDARD_FONTS|DM_LICENSED_EMBEDDING|DM_MULTILINGUAL_SUPPORT;
		*lpMargins = MAKELONG( 0, 0 );	// set margins to 0


		//*lpFlags = *lpFlags & ~2;	// disable font embedding
		//*lpFlags = *lpFlags & ~1;	// disable compression
		//*lpMargins = MAKELONG( 0, 0 );	// set margins to 0

		// create DC
		CDC	dc;
		dc.CreateDC( _T("winspool"), lpDeviceName, NULL, lpDevMode );

		dc.SetMapMode( MM_LOMETRIC );

		CFont	font; 
		CFont	*oldFont;
		font.CreateFont( -72, 0, 0, 0, 0, FALSE, FALSE, 0, 0, 0, 0,
							0, 0, "Arial" );

		// print something
		DOCINFO di;
		memset( &di, 0, sizeof( di ) );
		di.cbSize = sizeof( DOCINFO );
		di.lpszDocName = _T("My document");

		//di.lpszOutput = _T("C:\\temp\\amyuni_devmode.PDF");

		::SetDefaultFileName (((CDevModeApp*)AfxGetApp ())->m_converter, _T("C:\\temp\\amyuni_devmode.PDF"));

		// activate printer before starting to print
		// set the license information
		::EnablePrinter (((CDevModeApp*)AfxGetApp ())->m_converter, STRLICENSETO, STRACTIVATIONCODE);

		dc.StartDoc( &di );
		oldFont = dc.SelectObject( &font );

		dc.StartPage();
		
		dc.TextOut( 100, -100, _T( "Amyuni Technologies - On Page 1" ), lstrlen( _T( "Amyuni Technologies - On Page 1" ) ) );
		dc.EndPage();

		dc.StartPage();
		dc.TextOut( 100, -100, _T( "Amyuni Technologies - On Page 2" ), lstrlen( _T( "Amyuni Technologies - On Page 2" ) ) );

		if ( oldFont )
			dc.SelectObject( oldFont );
		dc.EndPage();

		dc.EndDoc();

		// free allocated memory
		ClosePrinter( hPrinter );
		GlobalFreePtr( lpDevMode );
	return true;
}
